Attribute VB_Name = "mdDrawGeomTol"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to Create a Geometric Tolerance

Function DrawGeomTol(Design, drawdoc, graph)

'To get the global application object
GetApplicationObject

'Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

'get paper geometry
Dim geom As zGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

' create geomtol
Dim tolerance As aGeomTol
Set tolerance = app.GetClass("GeomTol").CreateGeomTol(ddetail, geom)

Dim Callout As aGeomTolCallout
Set Callout = app.GetClass("GeomTolCallout").CreateGeomTolCallout(tolerance)

Dim newgeomtol As aGeomTol
Set newgeomtol = Callout.GetTolerance()

newgeomtol.SetTolerance 0.02
newgeomtol.SetType 1
newgeomtol.SetFeatureModifier 2

'Set the position for the dimension line
Dim textLocation As ZVector
Set textLocation = app.GetClass("Vector").CreateVector(0.1, 0.1, 0)

Dim calloutgroup As aCalloutGroup
'0.005 is the text height
Set calloutgroup = app.GetClass("CalloutGroup").CreateCalloutGroup(Callout, textLocation, 0.005)
calloutgroup.SetControlPoint 1, textLocation

draw.AddCalloutGroup calloutgroup

' create feature leader
Dim leader As aLeader
Set leader = app.GetClass("FeatureLeader").CreateFeatureLeader(calloutgroup, geom)
draw.AddLeader leader

'Add CenterLine
'To be done



End Function
